/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.registry.block;

import com.redpxnda.respawnobelisks.config.ChargeConfig;
import com.redpxnda.respawnobelisks.config.CurseConfig;
import com.redpxnda.respawnobelisks.config.ReviveConfig;
import com.redpxnda.respawnobelisks.config.TeleportConfig;
import com.redpxnda.respawnobelisks.config.TrustedPlayersConfig;
import com.redpxnda.respawnobelisks.data.listener.ObeliskCore;
import com.redpxnda.respawnobelisks.data.listener.ObeliskInteraction;
import com.redpxnda.respawnobelisks.network.ModPackets;
import com.redpxnda.respawnobelisks.network.ParticleAnimationPacket;
import com.redpxnda.respawnobelisks.network.PlaySoundPacket;
import com.redpxnda.respawnobelisks.network.PlayTotemAnimationPacket;
import com.redpxnda.respawnobelisks.registry.ModRegistries;
import com.redpxnda.respawnobelisks.registry.block.entity.RespawnObeliskBlockEntity;
import com.redpxnda.respawnobelisks.util.CoreUtils;
import com.redpxnda.respawnobelisks.util.ObeliskUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RespawnObeliskBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty WILD = BooleanProperty.m_61465_((String)"wild");
    public static final DirectionProperty RESPAWN_SIDE = DirectionProperty.m_156003_((String)"respawn_side");
    private static final VoxelShape HITBOX_BOTTOM_BASE = Block.m_49796_((double)1.5, (double)1.0, (double)1.5, (double)14.5, (double)32.0, (double)14.5);
    private static final VoxelShape HITBOX_BOTTOM_TRIM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape AABB_BOTTOM = Shapes.m_83110_((VoxelShape)HITBOX_BOTTOM_BASE, (VoxelShape)HITBOX_BOTTOM_TRIM);
    private static final VoxelShape HITBOX_TOP_BASE = Block.m_49796_((double)1.5, (double)-15.0, (double)1.5, (double)14.5, (double)16.0, (double)14.5);
    private static final VoxelShape HITBOX_TOP_TRIM = Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)-13.0, (double)16.0);
    private static final VoxelShape AABB_TOP = Shapes.m_83110_((VoxelShape)HITBOX_TOP_BASE, (VoxelShape)HITBOX_TOP_TRIM);
    @Nullable
    public final ResourceKey<Level> obeliskHomeDimension;

    public RespawnObeliskBlock(BlockBehaviour.Properties pProperties, @Nullable ResourceKey<Level> obeliskDimension) {
        super(pProperties);
        this.obeliskHomeDimension = obeliskDimension;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)RESPAWN_SIDE, (Comparable)Direction.NORTH)).m_61124_((Property)WILD, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7420_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? AABB_BOTTOM : AABB_TOP;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (pFacing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (pFacing == Direction.UP)) {
            return pFacingState.m_60713_((Block)this) && pFacingState.m_61143_(HALF) != doubleblockhalf ? pState : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && pFacing == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        if (blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(pContext)) {
            return (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        pLevel.m_7731_(pPos.m_7494_(), (BlockState)pState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HALF, RESPAWN_SIDE, WILD});
    }

    public boolean m_7278_(BlockState state) {
        return ((DoubleBlockHalf)state.m_61143_(HALF)).equals((Object)DoubleBlockHalf.LOWER);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity;
        if (((DoubleBlockHalf)state.m_61143_(HALF)).equals((Object)DoubleBlockHalf.LOWER) && level.m_7702_(pos) != null && (blockEntity = level.m_7702_(pos)) instanceof RespawnObeliskBlockEntity) {
            RespawnObeliskBlockEntity blockEntity2 = (RespawnObeliskBlockEntity)blockEntity;
            return (int)(blockEntity2.getCharge(null) * 3.0 / 20.0);
        }
        return 0;
    }

    public Optional<Vec3> getRespawnLocation(BlockState state, BlockPos pos, ServerLevel level, ServerPlayer player) {
        return this.getRespawnLocation(false, true, false, state, pos, level, player);
    }

    public Optional<Vec3> getRespawnLocation(boolean isTeleport, boolean shouldCost, boolean forceCurse, BlockState state, BlockPos pos, ServerLevel level, ServerPlayer player) {
        RespawnObeliskBlockEntity blockEntity;
        BlockEntity blockEntity2;
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            pos = pos.m_7495_();
            state = level.m_8055_(pos);
        }
        if (level.m_7702_(pos) != null && (blockEntity2 = level.m_7702_(pos)) instanceof RespawnObeliskBlockEntity && !(blockEntity = (RespawnObeliskBlockEntity)blockEntity2).getCoreInstance().isEmpty() && (TrustedPlayersConfig.allowObeliskRespawning || blockEntity.isPlayerTrusted(player.m_6302_()))) {
            if (!CurseConfig.enableCurse) {
                forceCurse = false;
            }
            double charge = blockEntity.getCharge((Player)player);
            double cost = !shouldCost ? 0.0 : (isTeleport ? TeleportConfig.teleportationChargeCost : (double)ChargeConfig.obeliskDepleteAmount);
            for (ObeliskInteraction i : ObeliskInteraction.RESPAWN_INTERACTIONS.get((Object)ObeliskInteraction.Injection.START)) {
                ObeliskInteraction.Manager manager = new ObeliskInteraction.Manager(cost, null);
                i.respawnHandler.accept((Object)player, (Object)blockEntity, (Object)manager);
                cost = manager.cost;
            }
            if (charge - cost >= 0.0 && shouldCost && !forceCurse) {
                player.m_21195_((MobEffect)ModRegistries.IMMORTALITY_CURSE.get());
            }
            MobEffectInstance mei = null;
            if (player.m_21023_((MobEffect)ModRegistries.IMMORTALITY_CURSE.get()) && (mei = player.m_21124_((MobEffect)ModRegistries.IMMORTALITY_CURSE.get())).m_19564_() >= CurseConfig.curseMaxLevel - 1) {
                return Optional.empty();
            }
            boolean hasPlayedCurseAnim = false;
            if (CurseConfig.enableCurse && (charge - cost < 0.0 || forceCurse) && shouldCost) {
                int amplifier;
                int n = isTeleport ? (mei != null ? Math.min(mei.m_19564_() + CurseConfig.curseLevelIncrement, CurseConfig.curseMaxLevel - 1) : CurseConfig.curseLevelIncrement - 1) : (amplifier = CurseConfig.curseMaxLevel + 1);
                if (!player.m_21023_((MobEffect)ModRegistries.IMMORTALITY_CURSE.get()) || isTeleport) {
                    player.m_7292_(new MobEffectInstance((MobEffect)ModRegistries.IMMORTALITY_CURSE.get(), CurseConfig.curseDuration, amplifier));
                }
                ObeliskUtils.curseHandler(level, player, pos, state);
                hasPlayedCurseAnim = true;
            }
            if (shouldCost && !hasPlayedCurseAnim) {
                blockEntity.chargeAndAnimate((Player)player, -cost);
            } else if (shouldCost) {
                blockEntity.decreaseCharge((Player)player, cost);
            }
            BlockPos spawnPos = pos.m_121945_((Direction)state.m_61143_((Property)RESPAWN_SIDE));
            Vec3 vec = new Vec3((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
            for (ObeliskInteraction i : ObeliskInteraction.RESPAWN_INTERACTIONS.get((Object)ObeliskInteraction.Injection.END)) {
                ObeliskInteraction.Manager manager = new ObeliskInteraction.Manager(cost, vec);
                i.respawnHandler.accept((Object)player, (Object)blockEntity, (Object)manager);
                vec = manager.getSpawnLocActual();
            }
            return Optional.of(vec);
        }
        return Optional.empty();
    }

    public InteractionResult m_6227_(BlockState state, Level pLevel, BlockPos pos, Player pPlayer, InteractionHand hand, BlockHitResult hitResult) {
        if (pLevel.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            pos = pos.m_7495_();
            state = pLevel.m_8055_(pos);
        }
        if (pPlayer instanceof ServerPlayer) {
            BlockEntity blockEntity;
            ServerLevel level;
            ServerPlayer player = (ServerPlayer)pPlayer;
            if (pLevel instanceof ServerLevel && (level = (ServerLevel)pLevel).m_7702_(pos) != null && (blockEntity = level.m_7702_(pos)) instanceof RespawnObeliskBlockEntity) {
                RespawnObeliskBlockEntity blockEntity2 = (RespawnObeliskBlockEntity)blockEntity;
                if (TrustedPlayersConfig.allowObeliskInteraction || blockEntity2.isPlayerTrusted(player.m_6302_())) {
                    ResourceLocation rl;
                    if (pPlayer.m_21205_().m_150930_(Items.f_41829_) && pPlayer.m_21206_().m_150930_(Items.f_42210_)) {
                        pLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)WILD, (Comparable)Boolean.valueOf(true)), 3);
                        blockEntity2.hasRandomCharge = true;
                        return InteractionResult.SUCCESS;
                    }
                    double charge = blockEntity2.getCharge((Player)player);
                    if (this.obeliskHomeDimension != null && level.m_46472_() != this.obeliskHomeDimension) {
                        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                        level.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 3);
                        level.m_7731_(pos.m_7495_(), Blocks.f_50016_.m_49966_(), 3);
                        level.m_7703_(null, DamageSource.m_19334_(), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5.0f, true, Explosion.BlockInteraction.DESTROY);
                        return InteractionResult.SUCCESS;
                    }
                    if (player.m_6144_() && player.m_21205_().m_41619_() && !blockEntity2.getItemStack().m_41619_()) {
                        return this.takeCore(player, blockEntity2);
                    }
                    if (blockEntity2.getItemStack().m_41619_() && ObeliskCore.CORES.containsKey(rl = Registry.f_122827_.m_7981_((Object)player.m_21205_().m_41720_()))) {
                        return this.placeCore(player, blockEntity2, rl);
                    }
                    if (this.clickInteractions((Player)player, blockEntity2)) {
                        return InteractionResult.SUCCESS;
                    }
                    Optional itemHolder = Registry.f_122827_.m_6612_(new ResourceLocation(ReviveConfig.revivalItem));
                    if (CoreUtils.hasInteraction(blockEntity2.getCoreInstance(), ObeliskInteraction.REVIVE) && itemHolder.isPresent() && player.m_21205_().m_41720_() == itemHolder.get() && !player.m_36335_().m_41519_(player.m_21205_().m_41720_()) && !blockEntity2.getItemNbt().m_128456_() && blockEntity2.getItemNbt().m_128441_("tag") && blockEntity2.getItemNbt().m_128469_("tag").m_128441_("RespawnObeliskData")) {
                        if (this.reviveEntities((Item)itemHolder.get(), blockEntity2, player, level, pos)) {
                            return InteractionResult.SUCCESS;
                        }
                    } else if (blockEntity2.getCoreInstance().isEmpty()) {
                        player.m_213846_((Component)Component.m_237115_((String)"text.respawnobelisks.no_core"));
                    } else if (charge <= 0.0 && !ChargeConfig.allowEmptySpawnSetting) {
                        player.m_213846_((Component)Component.m_237115_((String)"text.respawnobelisks.no_charge"));
                    } else {
                        int degrees = 90;
                        if (state.m_61143_((Property)RESPAWN_SIDE) == Direction.NORTH) {
                            degrees = 180;
                        } else if (state.m_61143_((Property)RESPAWN_SIDE) == Direction.EAST) {
                            degrees = -90;
                        } else if (state.m_61143_((Property)RESPAWN_SIDE) == Direction.SOUTH) {
                            degrees = 0;
                        }
                        if (player.m_8961_() != null && !player.m_8961_().equals((Object)pos) || player.m_8961_() == null) {
                            List players = level.m_8795_(p -> ObeliskUtils.getAABB(blockEntity2.m_58899_()).m_82393_(p.m_20185_(), p.m_20186_(), p.m_20189_()));
                            ModPackets.CHANNEL.sendToPlayers((Iterable)players, (Object)new PlaySoundPacket(Registry.f_122821_.m_6612_(new ResourceLocation(ChargeConfig.obeliskSetSpawnSound)).orElse(SoundEvents.f_12490_), 1.0f, 1.0f));
                        }
                        player.m_9158_(level.m_46472_(), pos, (float)degrees, false, true);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.FAIL;
    }

    public boolean clickInteractions(Player player, RespawnObeliskBlockEntity blockEntity) {
        if (player.m_36335_().m_41519_(player.m_21205_().m_41720_())) {
            return false;
        }
        ObeliskCore.Instance core = blockEntity.getCoreInstance();
        boolean returnValue = false;
        for (ObeliskInteraction interaction : ObeliskInteraction.RIGHT_CLICK_INTERACTIONS) {
            if (!CoreUtils.hasInteraction(core, interaction.id)) continue;
            boolean bl = (Boolean)interaction.clickHandler.apply((Object)player, (Object)player.m_21205_(), (Object)blockEntity);
            returnValue = !returnValue ? bl : returnValue;
        }
        return returnValue;
    }

    public boolean reviveEntities(Item item, RespawnObeliskBlockEntity blockEntity, ServerPlayer player, ServerLevel level, BlockPos pos) {
        ListTag listTag;
        if (!blockEntity.getItemTag().m_128469_("RespawnObeliskData").m_128441_("SavedEntities")) {
            blockEntity.getItemTag().m_128469_("RespawnObeliskData").m_128365_("SavedEntities", (Tag)new ListTag());
        }
        if (!(listTag = blockEntity.getItemTag().m_128469_("RespawnObeliskData").m_128437_("SavedEntities", 10)).isEmpty()) {
            boolean hasFired = false;
            int count = 0;
            for (Tag tag : listTag) {
                Entity toSummon;
                CompoundTag compound;
                if (count >= ReviveConfig.maxEntities) break;
                if (!(tag instanceof CompoundTag) || !(compound = (CompoundTag)tag).m_128441_("uuid") || !compound.m_128441_("type") || !compound.m_128441_("data")) continue;
                Level level2 = player.f_19853_;
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    Entity entity = serverLevel.m_8791_(compound.m_128342_("uuid"));
                    if ((entity == null || !entity.m_6084_()) && blockEntity.getCharge((Player)player) - ReviveConfig.revivalCost < 0.0) {
                        player.m_213846_((Component)Component.m_237115_((String)"text.respawnobelisks.insufficient_charge"));
                        break;
                    }
                    if (entity != null && entity.m_6084_()) continue;
                }
                if ((toSummon = ((EntityType)Registry.f_122826_.m_7745_(ResourceLocation.m_135820_((String)compound.m_128461_("type")))).m_20615_(player.f_19853_)) == null) continue;
                toSummon.m_20258_(compound.m_128469_("data"));
                toSummon.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.5, (double)pos.m_123343_() + 0.5);
                player.f_19853_.m_7967_(toSummon);
                blockEntity.decreaseCharge((Player)player, ReviveConfig.revivalCost);
                hasFired = true;
                ++count;
            }
            if (hasFired) {
                blockEntity.checkLimbo(true);
                ModPackets.CHANNEL.sendToPlayer(player, (Object)new PlayTotemAnimationPacket(item));
                if (!player.m_7500_()) {
                    player.m_21205_().m_41774_(1);
                }
                List players = level.m_8795_(p -> ObeliskUtils.getAABB(blockEntity.m_58899_()).m_82393_(p.m_20185_(), p.m_20186_(), p.m_20189_()));
                ModPackets.CHANNEL.sendToPlayers((Iterable)players, (Object)new ParticleAnimationPacket("totem", player.m_19879_(), pos));
            }
        }
        return true;
    }

    public InteractionResult takeCore(ServerPlayer player, RespawnObeliskBlockEntity blockEntity) {
        player.m_21008_(InteractionHand.MAIN_HAND, blockEntity.getItemStack());
        blockEntity.setCoreInstance(ObeliskCore.Instance.EMPTY);
        blockEntity.checkLimbo(false);
        blockEntity.updateObeliskName();
        blockEntity.syncWithClient();
        ModPackets.CHANNEL.sendToPlayer(player, (Object)new PlaySoundPacket(SoundEvents.f_11675_, 1.0f, 1.0f));
        return InteractionResult.SUCCESS;
    }

    public InteractionResult placeCore(ServerPlayer player, RespawnObeliskBlockEntity blockEntity, ResourceLocation location) {
        ItemStack toAdd = player.m_21205_().m_41777_();
        toAdd.m_41764_(1);
        blockEntity.setCoreInstance(toAdd, ObeliskCore.CORES.get(location));
        blockEntity.checkLimbo(false);
        blockEntity.updateObeliskName();
        blockEntity.syncWithClient();
        player.m_21205_().m_41774_(1);
        ModPackets.CHANNEL.sendToPlayer(player, (Object)new PlaySoundPacket(SoundEvents.f_11675_, 1.0f, 1.0f));
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos pos, BlockState newBlockState, boolean isMoving) {
        if (blockState.m_60713_(newBlockState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RespawnObeliskBlockEntity) {
            RespawnObeliskBlockEntity be = (RespawnObeliskBlockEntity)blockEntity;
            if (!be.getItemStack().m_41619_()) {
                Containers.m_18992_((Level)level, (double)((double)pos.m_123341_() + 0.5), (double)pos.m_123342_(), (double)((double)pos.m_123343_() + 0.5), (ItemStack)be.getItemStack());
            }
            if (be.hasStoredItems) {
                be.storedItems.values().forEach(inv -> inv.dropAll(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5));
            }
        }
        super.m_6810_(blockState, level, pos, newBlockState, isMoving);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter getter, BlockPos pos) {
        BlockEntity be;
        if (((DoubleBlockHalf)state.m_61143_(HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            pos = pos.m_7495_();
        }
        if ((be = getter.m_7702_(pos)) instanceof RespawnObeliskBlockEntity) {
            RespawnObeliskBlockEntity blockEntity = (RespawnObeliskBlockEntity)be;
            if (!TrustedPlayersConfig.allowObeliskBreaking && !blockEntity.isPlayerTrusted(player.m_6302_())) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_240418_((Component)Component.m_237115_((String)"text.respawnobelisks.untrusted"), true);
                }
                return 0.0f;
            }
            if (!blockEntity.getItemStack().m_41619_() && !player.m_6144_()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_240418_((Component)Component.m_237115_((String)"text.respawnobelisks.has_core"), true);
                }
                return 0.0f;
            }
            if (blockEntity.hasStoredItems && !player.m_6144_()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_240418_((Component)Component.m_237115_((String)"text.respawnobelisks.items_are_stored"), true);
                }
                return 0.0f;
            }
            if (blockEntity.hasTeleportingEntity) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_240418_((Component)Component.m_237115_((String)"text.respawnobelisks.wormhole_open"), true);
                }
                return 0.0f;
            }
        }
        return super.m_5880_(state, player, getter, pos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (((DoubleBlockHalf)pState.m_61143_(HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            return null;
        }
        return ((BlockEntityType)ModRegistries.RESPAWN_OBELISK_BE.get()).m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModRegistries.RESPAWN_OBELISK_BE.get() ? (pLevel, pos, blockState, be) -> {
            if (be instanceof RespawnObeliskBlockEntity) {
                RespawnObeliskBlockEntity blockEntity = (RespawnObeliskBlockEntity)be;
                RespawnObeliskBlockEntity.tick(pLevel, pos, blockState, blockEntity);
            }
        } : null;
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener m_214009_(ServerLevel serverLevel, T blockEntity) {
        RespawnObeliskBlockEntity robe;
        return blockEntity instanceof RespawnObeliskBlockEntity ? (robe = (RespawnObeliskBlockEntity)blockEntity) : null;
    }
}

